/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.collect.Ordering;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.util.Comparators;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class Bom
implements Iterable<MaterialQuantity> {
    public static final String DEFAULT_NAME = "";
    private final List<MaterialQuantity> ingredients;
    private final String name;
    private static Comparator<Bom> fullComparator;

    public Bom(List<MaterialQuantity> ingredients) {
        this(ingredients, DEFAULT_NAME);
    }

    public Bom(List<MaterialQuantity> ingredients, String name) {
        this.name = name;
        this.ingredients = Collections.unmodifiableList(ingredients);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<MaterialQuantity> iterator() {
        return this.ingredients.iterator();
    }

    public int size() {
        return this.ingredients.size();
    }

    @Nonnull
    public List<MaterialQuantity> ingredients() {
        return this.ingredients;
    }

    @Nonnull
    public Set<Material> materials() {
        HashSet<Material> mats = new HashSet<Material>();
        for (MaterialQuantity ingredient : this.ingredients) {
            mats.add(ingredient.getMaterial());
        }
        return mats;
    }

    public double getQty(Material material) {
        for (MaterialQuantity ingredient : this.ingredients) {
            if (ingredient.getMaterial() != material) continue;
            return ingredient.getQty();
        }
        throw new IllegalArgumentException(String.format("Material %s not present in bom %s.", material, this.name));
    }

    public double getBatch(Material material) {
        for (MaterialQuantity ingredient : this.ingredients) {
            if (ingredient.getMaterial() != material) continue;
            return ingredient.getBatch();
        }
        throw new IllegalArgumentException(String.format("Material %s not present in bom %s.", material, this.name));
    }

    public String toString() {
        return this.ingredients.toString();
    }

    public static Comparator<Bom> fullComparator() {
        if (fullComparator == null) {
            fullComparator = Ordering.from(new Comparator<Bom>(){
                Comparator<List<MaterialQuantity>> ingrComp = Comparators.listComparator(MaterialQuantity.comparator());

                @Override
                public int compare(Bom o1, Bom o2) {
                    return this.ingrComp.compare(o1.ingredients(), o2.ingredients());
                }
            }).nullsLast();
        }
        return fullComparator;
    }
}

